<?php
  
  error_reporting(E_ALL);

  $dump=getDump();
  // if we want the dump to download to a file we use something like this....
  if(isset($_POST['asFile']))
	{
	header("Cache-Control: public");
	if(isset($_POST['compressType']) && $_POST['compressType']=='gzip' && gzipString($dump) != FALSE)
		{
		$dump = gzipString($dump);
		$filename = 'SQLiteAdmin.sql.gz';
		header("Content-Type: application/x-gzip");
		}
	elseif(isset($_POST['compressType']) && $_POST['compressType']=='bzip' && bzip2String($dump) != FALSE)
		{
		$dump=bzip2String($dump);
		$filename = 'SQLiteAdmin.sql.bz2';
                header("Content-Type: application/bzip");
                }
	else
		{
		$filename = 'SQLiteAdmin.sql';
		header("Content-Type: application/zip");
		}

	$len=strlen($dump);	
	header("Content-Disposition: inline; filename=$filename");
	header("Accept-Ranges: bytes");
	header("Content-Length: {$len}");
	echo $dump;
	}
  else
	{
	header("Location: index.php?page=exportTable2&amp;dbname=$_GET[dbname]&amp;dumpType=$_POST[dumpType]&amp;tableName=$_GET[tableName]");
	}

function gzipString($string){
  if(!function_exists('gzcompress'))
	{
	return FALSE;
	}
  else
	{
	return gzencode($string, 9);
	}
}

function bzip2String($string){
  if(!function_exists('bzcompress'))
        {
        return FALSE;
        }
  else
        {
        return bzcompress($string, 9);
        }
}
                                                                                                                       

function getDump(){

  session_start();

  require('./inc/sqlite.php');
  $sqlite = new sqlite;

  if(isset($_GET['tableName']))
        {
        // assign the array of tables to a var
        $tableName = $_GET['tableName'];
        }
                                                                                                                        
  // add the dump prefix message
  $dump = $sqlite->dumpPrefix();
  // if we want structure of sql only
  if($_POST['dumpType']=='structure')
        {
	// gets the table structure
	$dump .= $sqlite->dumpTableStructure($tableName);
        }
  // if we want to dump structure and data
  elseif($_POST['dumpType']=='structureData')
        {
	// gets the table structure
	$dump .= $sqlite->dumpTableStructure($tableName);
	// gets the table data
	$dump .= $sqlite->dumpTable($tableName);
        }
  // if we want to dump only the data
  elseif($_POST['dumpType']=='dataOnly')
        {
	// gets the table data
	$dump .= $sqlite->dumpTable($tableName);
	}
  return $dump;
}

?>
