<?php

  error_reporting(E_ALL);

class sqlite{


  public $topMenuArray;
  public $version = '0.0.4';
  public $limit = 30;
  public $offset = 0;

function __construct(){
  include_once('./inc/config.php');
  if(isset($_GET['dbname']) && $this->checkDbname()=='TRUE')
	{
	$this->dbname=$_GET['dbname'];
	}

  // assign the values for the topmenu select box from the dbnames
  // in the config file
  $this->topMenuArray=$dbname;  

  // this is the array of pages allowed to included in the script
  // any other page set in GET will not work
  $this->pageArray=array(
	'searchDatabase2',
	'searchDatabase',
	'sql',
	'sql2',
	'exportTable',
	'exportTable2',
	'exportDatabase',
	'exportDatabase2',
	'install',
	'editRecord',
	'editRecord2',
	'ChangeLog',
	'TODO',
	'tableProperties',
	'dropTable',
	'dropTable2',
	'dropDatabase',
	'dropDatabase2',
	'createTable',
	'createTable2',
	'createTable3',
	'listTables',
	'browse',
	'insert',
	'insert2',
	'deleteRecord',
	'deleteRecord2',
	'emptyTable',
	'emptyTable2',
	'createDb',
	'createDb2',
	'credits');
}

function conn(){
  if($db = @sqlite_open($this->dbname, 0666, $sqliteerror))
	{
  	return $db;
	}
  else
	{
	return FALSE;
	}
}


function query($sql){
  if(is_resource($this->conn()))
	{
	// Use sqlite_unbufferd_query to minimise overhead from buffering 
	if($res=@sqlite_unbuffered_query($this->conn(), $sql))
		{
		return $res;
		}
	else
		{
		// return an error if it all goes belly up
		return sqlite_error_string(sqlite_last_error($this->conn()));
		}
	}
}


function sanityCheck($name, $length){

  if(strlen($name<$length))
	{
	return TRUE;
	}
  else
	{
	return FALSE;
	}
}

// returns the name of the db, not the path
function getDBName(){
  // explode the path into bits
  $bits = explode('/', $this->dbname);
  // get the second last array member
  // the last is the filename
  $lastdir=sizeof($bits)-1;
  return $bits[$lastdir];
}

function getFileName($path){
  $path_parts = pathinfo($path);
  return $path_parts["basename"];
}

function checkDbname(){
  return TRUE;
}

function checkGet(){
  foreach($_GET as $var)
	{
	if($var =='')
		{ 
		return TRUE;
		}
	else
		{
		return FALSE;
		}
	}
}

function queryTypes(){
  return array(
	'select' => 'SELECT',
	'insert' => 'INSERT',
	'emptyTable' => 'EMPTY',
	'dropTable' => 'DROP');
}

function checkQueryType($str){
  // put the string of words into an array
  $wordArray = str_word_count($str, 1);
  // get the first word of the string and uppercase it
  $queryType = strtoupper($wordArray[0]);
  if(in_array($queryType, $this->queryTypes()))
	{
	return array_search($queryType, $this->queryTypes());
	}
  else
	{
	return FALSE;
	}
}

function dumpTableStructure($tableName){
$dump = "\n".'#'."\n".'#SQLite Admin Structure Dump for table '.$tableName."\n".'#'."\n"; 
$isql = "SELECT * FROM sqlite_master WHERE tbl_name='$tableName'";
  $result=$this->query($isql);
  while($row=sqlite_fetch_array($result))
	{
	$dump .=  $row['4'].'<br />';
	}
  return $dump;
}


// supplies an array of _all_ the tables in the database
function getTableArray(){
  $sql = "Select Name FROM sqlite_master WHERE type='table' ORDER BY Name";
  $res=$this->query($sql);
  while($row=sqlite_fetch_array($res))
	{
	$tableArray[]=$row[0];
	}
  return $tableArray;
}


function dumpTable($tableName){

  // initialize the dump
  $dump='';
                                                                                                                         
  // echo a little identifier in the dump
  $dump .= "\n".'#'."\n".'### SQLite Admin Data Dump for table '.$tableName."\n".'#'."\n";
  // select * from the table
  $tableSQL="SELECT * FROM ".$tableName;
  // put the table results in a variable
  $tableRes=$this->query($tableSQL);
  // check for a valid return
  if(is_resource($tableRes))
	{
        // through the results from the SELECT * from table
        while($r=sqlite_fetch_array($tableRes))
		{
		// this will return eg: INSERT INTO my_table (
		$dump .= 'INSERT INTO '.$tableName.' VALUES ( ';
		// set a counter for the table rows
		$i=0;
		// get the values from each field
		while($i<sqlite_num_fields($tableRes))
			{
			// put some quotes around the value to be inserted
			$dump .= "'".$r[$i]."'";
			if($i < (sqlite_num_fields($tableRes)-1)) {$dump.=', ';}else{$dump.=');'."\n";}
			$i++;
			}
		}
	}
  else
	{
	$dump .=  '## Table is empty<br />';
	}
  return $dump;
}

function dumpPrefix(){
  $dp =  '##########################################################'."\n";
  $dp .= '###'."\n";
  $dp .= '### SQLite Admin Dump'."\n";
  $dp .= '### SQLite Version: '.$this->version."\n";
  $dp .= '### http://www.phpro.org/sqlite'."\n";
  $dp .= '###'."\n";
  $dp .= '### Host Name: '.$_SERVER['HTTP_HOST']."\n";
  $dp .= '### Dump Generated: '. date("l dS of F Y h:i a")."\n";
  $dp .= '### SQLite Version: '.sqlite_libversion()."\n";
  $dp .= '### PHP Version: '.phpversion()."\n";
  $dp .= '### Database: '.$this->getDbName()."\n";
  $dp .= '###'."\n";
  $dp .= '##########################################################'."\n\n";
  return $dp;
}


// check if the limit is correctly set
function getLimit($limit){
  if(is_numeric($limit) && $limit > 0)
	{
	return $limit;
	}
  else
	{
	return $this->limit;
	}
}


function getOffset($offset){
  // check if it is set and is a number
  if(is_numeric($offset) && $offset > 0)
	{
	// if it is ok return the value
	return $offset;
	}
  else
	{
	// if it is not a number, return the default value set in the constructor
	return $this->offset;
	}
}

function sqlite_field_type($table){
$p="PRAGMA show_datatypes = ON";
$this->query($p);
$sql="PRAGMA show_datatypes = ON; select id from $table where 0=1";
echo $sql;
$res=$this->query($sql);
// $sql="select * from sqlite_master where name = ".$table;
	print_r($res);
}

function getTitle(){
  // build the title for the browser
  $title ='';
  if(isset($_GET['dbname']))
	{
	// we will shorten the file path and just use the filename
  	$title .= $this->getFilename($_GET['dbname']);
	}
  if(isset($_GET['table']))
	{
	$title .= '.'.$_GET['table'].' on '.$_SERVER['HTTP_HOST'].' - ';
	}
  $title .= 'SQLite - '.$this->version;
  return $title;
}


    /**
    * this function attempts to get the length of a given field
    *
    * Fetches the final template output, and
    * echo's it to the browser.
    *
    * @param string $fieldname field name to get length of
    * @access public
    * @return array on success, zero on failure
    */

function getFieldLength($fieldname){
  // create a db resource
  $db = sqlite_open($_GET['dbname']);
  // get the coltypes array which contains the type and length eg VARCHAR(50)
  $colTypes = sqlite_fetch_column_types($db, $_GET['table']);
  // echo $colTypes[$fieldname];
  preg_match("/\((.*)\)/","$colTypes[$fieldname]" ,$arrMatches);
  if($arrMatches)
	{
  	return $arrMatches[1];
	}
  else
	{
	return 0;
	}
}

    /**
    * this function returns and sql query in the showsql div
    *
    *
    * @param string $sql sql query
    * @access public
    * @return string Returns a string
    */

function showSQL($sql){
  return '<div id="showSQL">SQL query:<br />'.highlight_string($sql, 1).'</div>';
}


    /**
    * this function returns and the changes from an sql query 
    * and formats them in the showsql div box
    *
    *
    * @access public
    * @return string Returns a string 
    */
function showChanges(){
  return '<div id="showSQL">Affected Rows:<br />'.sqlite_changes($this->conn()).'</div>';
}

} // end of class

?>
